//
// C++ Implementation: accountsetupitem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "accountsetupitem.h"

AccountSetupItem::AccountSetupItem( TDEListView* parent )
 : TDEListViewItem( parent )
{
  init();

}

AccountSetupItem::AccountSetupItem( TDEListView * parent, TQString & name )
  : TDEListViewItem( parent )
{
  init();

  //save account name
  _account = name;

  //set column text
  setText( 0, getAccountName() );
}

AccountSetupItem::~AccountSetupItem()
{
}

void AccountSetupItem::init( )
{
  //set default values
  _account          = DEFAULT_ACCOUNT_NAME;
  _server           = DEFAULT_ACCOUNT_SERVER;
  _protocol         = DEFAULT_ACCOUNT_PROTOCOL;
  _port             = DEFAULT_ACCOUNT_PORT_POP3;
  _user             = DEFAULT_ACCOUNT_USER;
  _password         = DEFAULT_ACCOUNT_PASSWORD;
  _passwordStorage  = DEFAULT_ACCOUNT_PASSWORD_STORAGE;
  _active           = DEFAULT_ACCOUNT_ACTIVE;
  _transferSecurity = DEFAULT_ACCOUNT_SECTRANSFER;

  //get application config object (kshowmailrc)
  config = tdeApp->config();
}

void AccountSetupItem::setAccountName( const TQString & name )
{
  _account = name;
}

TQString AccountSetupItem::getAccountName( ) const
{
  return _account;
}

void AccountSetupItem::setServer( const TQString & server )
{
  _server = server;
}

TQString AccountSetupItem::getServer( ) const
{
  return _server;
}

void AccountSetupItem::setProtocol( const TQString & protocol )
{
  _protocol = protocol;
}

TQString AccountSetupItem::getProtocol( ) const
{
  return _protocol;
}

void AccountSetupItem::setPort( int port )
{
  if( port >= 0 && port <= 65535 )
    _port = port;
  else
    _port = DEFAULT_ACCOUNT_PORT_POP3;
}

int AccountSetupItem::getPort( ) const
{
  return _port;
}

void AccountSetupItem::setUser( const TQString & user )
{
  _user = user;
}

TQString AccountSetupItem::getUser( ) const
{
  return _user;
}

void AccountSetupItem::setPassword( const TQString & password )
{
  _password = password;
}

TQString AccountSetupItem::getPassword( ) const
{
  return _password;
}

void AccountSetupItem::setPasswordStorageType( int type )
{
  if( type == CONFIG_VALUE_ACCOUNT_PASSWORD_DONT_SAVE || type == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_FILE || type == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_TDEWALLET )
    _passwordStorage = type;
  else
    _passwordStorage = DEFAULT_ACCOUNT_PASSWORD_STORAGE;
}

int AccountSetupItem::getPasswordStorageType( ) const
{
  return _passwordStorage;
}

void AccountSetupItem::setActive( bool active )
{
  _active = active;
}

bool AccountSetupItem::getActive( ) const
{
  return _active;
}

void AccountSetupItem::save() const
{
  config->setGroup( getAccountName() );

  config->writeEntry( CONFIG_ENTRY_ACCOUNT_NAME, getAccountName() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_SERVER, getServer() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_PROTOCOL, getProtocol().upper() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_PORT, getPort() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_USER, getUser() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_PASSWORD_STORAGE, getPasswordStorageType() );

  //save crypted password
  KURL url;
  url.setUser( getUser() );
  url.setHost( getServer() );
  url.setPass( getPassword() );

  if( getPasswordStorageType() == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_FILE )
    config->writeEntry( CONFIG_ENTRY_ACCOUNT_PASSWORD, crypt( url ) );
  else
    config->writeEntry( CONFIG_ENTRY_ACCOUNT_PASSWORD, TQString::null );

  //save password in TDEWallet if desired
  if( getPasswordStorageType() == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_TDEWALLET )
    TDEWalletAccess::savePassword( getAccountName(), getPassword() );

  config->writeEntry( CONFIG_ENTRY_ACCOUNT_ACTIVE, getActive() );
  config->writeEntry( CONFIG_ENTRY_ACCOUNT_SECTRANSFER, getTransferSecurity() );

}

void AccountSetupItem::load( )
{
  config->setGroup( getAccountName() );

  _server = config->readEntry( CONFIG_ENTRY_ACCOUNT_SERVER, DEFAULT_ACCOUNT_SERVER );
  _protocol = config->readEntry( CONFIG_ENTRY_ACCOUNT_PROTOCOL, DEFAULT_ACCOUNT_PROTOCOL );
  _port = config->readNumEntry( CONFIG_ENTRY_ACCOUNT_PORT, DEFAULT_ACCOUNT_PORT_POP3 );
  _user = config->readEntry( CONFIG_ENTRY_ACCOUNT_USER, DEFAULT_ACCOUNT_USER );
  _passwordStorage = config->readNumEntry( CONFIG_ENTRY_ACCOUNT_PASSWORD_STORAGE, DEFAULT_ACCOUNT_PASSWORD_STORAGE );

  if( _passwordStorage == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_FILE )
    _password = decrypt( config->readEntry( CONFIG_ENTRY_ACCOUNT_PASSWORD, DEFAULT_ACCOUNT_PASSWORD ) );
  else if( _passwordStorage == CONFIG_VALUE_ACCOUNT_PASSWORD_SAVE_TDEWALLET )
    _password = TDEWalletAccess::getPassword( getAccountName() );
  else
    _password = TQString::null;

  _active = config->readBoolEntry( CONFIG_ENTRY_ACCOUNT_ACTIVE, DEFAULT_ACCOUNT_ACTIVE );
  _transferSecurity = config->readNumEntry( CONFIG_ENTRY_ACCOUNT_SECTRANSFER, DEFAULT_ACCOUNT_SECTRANSFER );
}

void AccountSetupItem::setTransferSecurity( int type )
{
  if( type == CONFIG_VALUE_ACCOUNT_SECTRANSFER_NONE || type == CONFIG_VALUE_ACCOUNT_SECTRANSFER_SSL || type == CONFIG_VALUE_ACCOUNT_SECTRANSFER_TLS )
    _transferSecurity = type;
  else
    _transferSecurity = DEFAULT_ACCOUNT_SECTRANSFER;
}

int AccountSetupItem::getTransferSecurity( ) const
{
  return _transferSecurity;
}




