###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for lcms

if( WITH_LCMS )
    check_include_file( lcms2.h HAVE_LCMS2_H )
    if( HAVE_LCMS2_H )
        pkg_search_module( LCMS lcms2 )
        set( LCMS_HEADER lcms2.h )
     else()
        check_include_file( lcms.h  HAVE_LCMS_H  )
        if( HAVE_LCMS_H )
            pkg_search_module( LCMS lcms )
            set( LCMS_HEADER lcms.h )
          else()
            tde_message_fatal( "lcms is requested, but was not found on your system" )
        endif()
    endif()
    set( USE_LCMS 1 )
endif( WITH_LCMS )


##### check for OpenMP

if( WITH_OPENMP )
    find_package( OpenMP )
    if( OPENMP_FOUND )
        set( CMAKE_C_FLAGS   "${CMAKE_C_FLAGS}   ${OpenMP_C_FLAGS}"   )
        set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OpenMP_CXX_FLAGS}" )
     else()
        tde_message_fatal( "OpenMP is requested, but was not found on your system" )
    endif()
endif( WITH_OPENMP )


##### check for jpeg

if( BUILD_KDCRAW )
    find_package( JPEG )

    if( JPEG_FOUND )
        set( HAVE_JPEG 1 )
     else()
        tde_message_fatal( "jpeg library is required, but was not found on your system" )
    endif()

##### check for the math libc

    find_library( MATH_LIBC m )

endif( BUILD_KDCRAW )
