

#include "configdialog.h"

#include "configuration.h"
#include "configgeneralpage.h"
#include "configpluginspage.h"
#include "configenvironmentpage.h"
#include "configbackendspage.h"

/*#include "config_dialogue_interface.h"
#include "config_dialogue_backend_plugins.h"
#include "config_dialogue_backends.h"
#include "config_dialogue_en_decoder.h"
#include "config_dialogue_en_decoder_options.h"

#include "tools.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <tqlayout.h>
*/
//#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kpushbutton.h>

ConfigDialog::ConfigDialog( Config* _config, TQWidget *parent, const char *name, Page startPage )
    : KDialogBase(
        IconList,
        i18n("Settings"),
        Apply | Cancel | Default | Help | Ok,
        Ok, // default button
        parent,
        name,
        true, // modal
        true // separator
    )
{
    config = _config;

    //resize( 600, 400 );

    binaries = config->binaries;

    connect( this, TQ_SIGNAL(applyClicked()),
               this,TQ_SLOT(applyClickedSlot())
             );
    connect( this, TQ_SIGNAL(okClicked()),
               this,TQ_SLOT(okClickedSlot())
             );
    connect( this, TQ_SIGNAL(defaultClicked()),
               this,TQ_SLOT(defaultClickedSlot())
             );

    generalPage = addPage( i18n("General"), "misc" );
    configGeneralPage = new ConfigGeneralPage( config, generalPage, "configGeneralPage" );
    connect( configGeneralPage, TQ_SIGNAL(configChanged()),
               this, TQ_SLOT(configChanged())
    );
    connect( this, TQ_SIGNAL(saveGeneral()),
               configGeneralPage, TQ_SLOT(saveSettings())
    );
    connect( this, TQ_SIGNAL(resetGeneral()),
               configGeneralPage, TQ_SLOT(resetDefaults())
    );

    pluginsPage = addPage( i18n("Plugins"), "connect_creating" );
    configPluginsPage = new ConfigPluginsPage( config, pluginsPage, "configPluginsPage" );
    connect( configPluginsPage, TQ_SIGNAL(configChanged()),
               this, TQ_SLOT(configChanged())
    );
    connect( this, TQ_SIGNAL(savePlugins()),
               configPluginsPage, TQ_SLOT(saveSettings())
    );
    connect( this, TQ_SIGNAL(resetPlugins()),
               configPluginsPage, TQ_SLOT(resetDefaults())
    );

    environmentPage = addPage( i18n("Environment"), "filefind" );
    configEnvironmentPage = new ConfigEnvironmentPage( config, &binaries, environmentPage, "configEnvironmentPage" );
    connect( configEnvironmentPage, TQ_SIGNAL(configChanged()),
               this, TQ_SLOT(configChanged())
    );
    connect( this, TQ_SIGNAL(saveEnvironment()),
               configEnvironmentPage, TQ_SLOT(saveSettings())
    );
    connect( this, TQ_SIGNAL(resetEnvironment()),
               configEnvironmentPage, TQ_SLOT(resetDefaults())
    );

    backendsPage = addPage( i18n("Backends"), "preferences-system" );
    configBackendsPage = new ConfigBackendsPage( config, &binaries, backendsPage, "configBackendsPage" );
    connect( configBackendsPage, TQ_SIGNAL(configChanged()),
               this, TQ_SLOT(configChanged())
    );
    connect( this, TQ_SIGNAL(saveBackends()),
               configBackendsPage, TQ_SLOT(saveSettings())
    );
    connect( this, TQ_SIGNAL(resetBackends()),
               configBackendsPage, TQ_SLOT(resetDefaults())
    );
    connect( configEnvironmentPage, TQ_SIGNAL(rebuildBackendsPage()),
               configBackendsPage, TQ_SLOT(rebuild())
    );

    setConfigChanged( false );

    showPage( startPage );
}

ConfigDialog::~ConfigDialog()
{
}

TQFrame *ConfigDialog::addPage(const TQString &itemName, const TQString &iconName)
{
    return KDialogBase::addPage( itemName, TQString(), MainBarIcon(iconName,32) );
}

void ConfigDialog::setConfigChanged( const bool value )
{
    actionButton( Apply )->setEnabled(value);
}

void ConfigDialog::configChanged()
{
    setConfigChanged( true );
}

void ConfigDialog::applyClickedSlot()
{
    okClickedSlot();
    setConfigChanged( false );
}

void ConfigDialog::okClickedSlot()
{
    emit saveGeneral();
    emit savePlugins();
    emit saveEnvironment();
    emit saveBackends();
    config->write();
}

void ConfigDialog::defaultClickedSlot()
{
    int index = activePageIndex();
    TQStringList listDefaults;

    if( index == -1 )
        return;

    if( index == pageIndex(generalPage) )
    {
        emit resetGeneral();
        setConfigChanged( true );
    }
    else if( index == pageIndex(pluginsPage) )
    {
        emit resetPlugins();
        setConfigChanged( true );
    }
    else if( index == pageIndex(environmentPage) )
    {
        emit resetEnvironment();
        setConfigChanged( true );
    }
    else if( index == pageIndex(backendsPage) )
    {
        emit resetBackends();
        setConfigChanged( true );
    }
}

#include "configdialog.moc"
