//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQWidget;

/**

 Easy message dialog box.
 Provides convenience functions for some i18n'ed standard dialogs.
 The text in message boxes is wrapped automatically. The text may either
 be plaintext or richtext. If the text is plaintext, a newline-character
 may be used to indicate the end of a paragraph.
		@author Waldo Bastian (bastian@kde.org)

		@short    Easy message dialog box.

*/
public class KMessageBox implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KMessageBox(Class dummy){}

	/**
		 Button types.
				@short    Button types.
	*/
	public static final int Ok = 1;
	public static final int Cancel = 2;
	public static final int Yes = 3;
	public static final int No = 4;
	public static final int Continue = 5;

	public static final int QuestionYesNo = 1;
	public static final int WarningYesNo = 2;
	public static final int WarningContinueCancel = 3;
	public static final int WarningYesNoCancel = 4;
	public static final int Information = 5;
	public static final int Sorry = 7;
	public static final int Error = 8;
	public static final int QuestionYesNoCancel = 9;

	public static final int Notify = 1;
	public static final int AllowLink = 2;
	public static final int Dangerous = 4;
	public static final int PlainCaption = 8;
	public static final int NoExec = 16;

	public KMessageBox() {
		newKMessageBox();
	}
	private native void newKMessageBox();
	/**
		 Display a simple "question" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Question").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions like "Do you have a printer?"
			 The default button is "Yes". Pressing "Esc" selects "No".
		  		@return 'Yes' is returned if the Yes-button is pressed. 'No' is returned
          if the No-button is pressed.

		@short    Display a simple "question" dialog.
	*/
	public static native int questionYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes);
	public static native int questionYesNo(TQWidget parent, String text, String caption);
	public static native int questionYesNo(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int questionYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes);
	public static native int questionYesNoWId(long parent_id, String text, String caption);
	public static native int questionYesNoWId(long parent_id, String text);
	/**
		 Display a simple "question" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Question").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions like "Do you want to discard the message or save it for later?",
			 The default button is "Yes". Pressing "Esc" selects "Cancel".
			 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
		  		@return 'Yes' is returned if the Yes-button is pressed. 'No' is returned
          if the No-button is pressed.

		@short    Display a simple "question" dialog.
	*/
	public static native int questionYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes);
	public static native int questionYesNoCancel(TQWidget parent, String text, String caption);
	public static native int questionYesNoCancel(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int questionYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes);
	public static native int questionYesNoCancelWId(long parent_id, String text, String caption);
	public static native int questionYesNoCancelWId(long parent_id, String text);
	/**
		 Display a "question" dialog with a listbox to show information to the user
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the list is
		                empty, it doesn't show any listbox, working as questionYesNo.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Question").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions like "Do you really want to delete these files?"
		 And show the user exactly which files are going to be deleted in case
		 he presses "Yes"
			 The default button is "Yes". Pressing "Esc" selects "No".
		  		@return 'Yes' is returned if the Yes-button is pressed. 'No' is returned
          if the No-button is pressed.

		@short    Display a "question" dialog with a listbox to show information to the user
	*/
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist, String caption);
	public static native int questionYesNoList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist, String caption);
	public static native int questionYesNoListWId(long parent_id, String text, String[] strlist);
	/**
		 Display a "warning" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Warning").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions "Shall I update your configuration?"
		 The text should explain the implication of both options.
			 The default button is "No". Pressing "Esc" selects "No".
		  		@return <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
          if the No-button is pressed.

		@short    Display a "warning" dialog.
	*/
	public static native int warningYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNo(TQWidget parent, String text, String caption, KGuiItem buttonYes);
	public static native int warningYesNo(TQWidget parent, String text, String caption);
	public static native int warningYesNo(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoWId(long parent_id, String text, String caption, KGuiItem buttonYes);
	public static native int warningYesNoWId(long parent_id, String text, String caption);
	public static native int warningYesNoWId(long parent_id, String text);
	/**
		 Display a "warning" dialog with a listbox to show information to the user
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the list is
		                empty, it doesn't show any listbox, working as questionYesNo.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Question").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions like "Do you really want to delete these files?"
		 And show the user exactly which files are going to be deleted in case
		 he presses "Yes"
			 The default button is "No". Pressing "Esc" selects "No".
		  		@return 'Yes' is returned if the Yes-button is pressed. 'No' is returned
          if the No-button is pressed.

		@short    Display a "warning" dialog with a listbox to show information to the user
	*/
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist, String caption);
	public static native int warningYesNoList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist, String caption);
	public static native int warningYesNoListWId(long parent_id, String text, String[] strlist);
	/**
		 Display a "warning" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Warning").
			@param buttonContinue The text for the first button.
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 The second button always has the text "Cancel".
			 To be used for questions like "You are about to Print. Are you sure?"
		 the continueButton should then be labeled "Print".
			 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
		  		@return <code>Continue</code> is returned if the Continue-button is pressed.
          <code>Cancel</code> is returned if the Cancel-button is pressed.

		@short    Display a "warning" dialog.
	*/
	public static native int warningContinueCancel(TQWidget parent, String text, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancel(TQWidget parent, String text, String caption, KGuiItem buttonContinue, String dontAskAgainName);
	public static native int warningContinueCancel(TQWidget parent, String text, String caption, KGuiItem buttonContinue);
	public static native int warningContinueCancel(TQWidget parent, String text, String caption);
	public static native int warningContinueCancel(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningContinueCancelWId(long parent_id, String text, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancelWId(long parent_id, String text, String caption, KGuiItem buttonContinue, String dontAskAgainName);
	public static native int warningContinueCancelWId(long parent_id, String text, String caption, KGuiItem buttonContinue);
	public static native int warningContinueCancelWId(long parent_id, String text, String caption);
	public static native int warningContinueCancelWId(long parent_id, String text);
	/**
		 Display a "warning" dialog with a listbox to show information to the user.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the
		                list is empty, it doesn't show any listbox, working
		                as warningContinueCancel.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Warning").
			@param buttonContinue The text for the first button.
			@param dontAskAgainName If provided, a checkbox is added with which
		                further confirmation can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 The second button always has the text "Cancel".
			 To be used for questions like "You are about to Print. Are you sure?"
		 the continueButton should then be labeled "Print".
			 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
		  		@return <code>Continue</code> is returned if the Continue-button is pressed.
          <code>Cancel</code> is returned if the Cancel-button is pressed.

		@short    Display a "warning" dialog with a listbox to show information to the user.
	*/
	public static native int warningContinueCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonContinue, String dontAskAgainName);
	public static native int warningContinueCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonContinue);
	public static native int warningContinueCancelList(TQWidget parent, String text, String[] strlist, String caption);
	public static native int warningContinueCancelList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningContinueCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonContinue, String dontAskAgainName);
	public static native int warningContinueCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonContinue);
	public static native int warningContinueCancelListWId(long parent_id, String text, String[] strlist, String caption);
	public static native int warningContinueCancelListWId(long parent_id, String text, String[] strlist);
	/**
		 Display a Yes/No/Cancel "warning" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Warning").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further questions can be turned off. If turned off
		                all questions will be automatically answered with the
		                last answer (either Yes or No).
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions "Do you want to save your changes?"
		 The text should explain the implication of choosing 'No'.
			 The default button is "Yes". Pressing "Esc" selects "Cancel"
			 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
		  		@return <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
          if the No-button is pressed. <code>Cancel</code> is retunred if the Cancel-
          button is pressed.

		@short    Display a Yes/No/Cancel "warning" dialog.
	*/
	public static native int warningYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoCancel(TQWidget parent, String text, String caption, KGuiItem buttonYes);
	public static native int warningYesNoCancel(TQWidget parent, String text, String caption);
	public static native int warningYesNoCancel(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoCancelWId(long parent_id, String text, String caption, KGuiItem buttonYes);
	public static native int warningYesNoCancelWId(long parent_id, String text, String caption);
	public static native int warningYesNoCancelWId(long parent_id, String text);
	/**
		 Display a Yes/No/Cancel "warning" dialog with a listbox to show information
		 to the user.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the
		                list is empty, it doesn't show any listbox, working
		                as warningYesNoCancel.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Warning").
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontAskAgainName If provided, a checkbox is added with which
		                further questions can be turned off. If turned off
		                all questions will be automatically answered with the
		                last answer (either Yes or No).
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
		                If <code>dontAskAgainName</code> starts with a ':' then the setting
		                is stored in the global config file.
			@param options see OptionsType
			 To be used for questions "Do you want to save your changes?"
		 The text should explain the implication of choosing 'No'.
			 The default button is "Yes". Pressing "Esc" selects "Cancel"
			 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
				@return <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
          if the No-button is pressed. <code>Cancel</code> is retunred if the Cancel-
          button is pressed.

		@short    Display a Yes/No/Cancel "warning" dialog with a listbox to show information  to the user.
	*/
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist, String caption);
	public static native int warningYesNoCancelList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName);
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist, String caption, KGuiItem buttonYes);
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist, String caption);
	public static native int warningYesNoCancelListWId(long parent_id, String text, String[] strlist);
	/**
		 Display an "Error" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Error").
			@param options see OptionsType
			 Your program messed up and now it's time to inform the user.
		 To be used for important things like "Sorry, I deleted your hard disk."
			 If your program detects the action specified by the user is somehow
		 not allowed, this should never be reported with error(). Use sorry()
		 instead to explain to the user that this action is not allowed.
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			 NOTE: The OK button will always have the i18n'ed text '&OK'.
		  		@short    Display an "Error" dialog.
	*/
	public static native void error(TQWidget parent, String text, String caption, int options);
	public static native void error(TQWidget parent, String text, String caption);
	public static native void error(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void errorWId(long parent_id, String text, String caption, int options);
	public static native void errorWId(long parent_id, String text, String caption);
	public static native void errorWId(long parent_id, String text);
	/**
		 Display an "Error" dialog with a listbox.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the
		                list is empty, it doesn't show any listbox, working
		                as error().
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Error").
			@param options see OptionsType
			 Your program messed up and now it's time to inform the user.
		 To be used for important things like "Sorry, I deleted your hard disk."
			 If your program detects the action specified by the user is somehow
		 not allowed, this should never be reported with error(). Use sorry()
		 instead to explain to the user that this action is not allowed.
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			 NOTE: The OK button will always have the i18n'ed text '&OK'.
				@short    Display an "Error" dialog with a listbox.
	*/
	public static native void errorList(TQWidget parent, String text, String[] strlist, String caption, int options);
	public static native void errorList(TQWidget parent, String text, String[] strlist, String caption);
	public static native void errorList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void errorListWId(long parent_id, String text, String[] strlist, String caption, int options);
	public static native void errorListWId(long parent_id, String text, String[] strlist, String caption);
	public static native void errorListWId(long parent_id, String text, String[] strlist);
	/**
		 Displays an "Error" dialog with a "Details >>" button.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param details Detailed message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Error").
			@param options see OptionsType
			 Your program messed up and now it's time to inform the user.
		 To be used for important things like "Sorry, I deleted your hard disk."
			 The <code>details</code> message can conatin additional information about
		 the problem and can be shown on request to advanced/interested users.
			 If your program detects the action specified by the user is somehow
		 not allowed, this should never be reported with error(). Use sorry()
		 instead to explain to the user that this action is not allowed.
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			 NOTE: The OK button will always have the i18n'ed text '&OK'.
		  		@short    Displays an "Error" dialog with a "Details >>" button.
	*/
	public static native void detailedError(TQWidget parent, String text, String details, String caption, int options);
	public static native void detailedError(TQWidget parent, String text, String details, String caption);
	public static native void detailedError(TQWidget parent, String text, String details);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void detailedErrorWId(long parent_id, String text, String details, String caption, int options);
	public static native void detailedErrorWId(long parent_id, String text, String details, String caption);
	public static native void detailedErrorWId(long parent_id, String text, String details);
	/**
		 Like detailedError
			 This function will return immediately, the messagebox will be shown
		 once the application enters an event loop and no other messagebox
		 is being shown.
			 Note that if the parent gets deleted, the messagebox will not be
		 shown.
		   		@short    Like detailedError
	*/
	public static native void queuedDetailedError(TQWidget parent, String text, String details, String caption);
	public static native void queuedDetailedError(TQWidget parent, String text, String details);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void queuedDetailedErrorWId(long parent_id, String text, String details, String caption);
	public static native void queuedDetailedErrorWId(long parent_id, String text, String details);
	/**
		 Display an "Sorry" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Sorry").
			@param options see OptionsType
			 Either your program messed up and asks for understanding
		 or your user did something stupid.
			 To be used for small problems like
		 "Sorry, I can't find the file you specified."
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			 NOTE: The ok button will always have the i18n'ed text '&OK'.
		  		@short    Display an "Sorry" dialog.
	*/
	public static native void sorry(TQWidget parent, String text, String caption, int options);
	public static native void sorry(TQWidget parent, String text, String caption);
	public static native void sorry(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void sorryWId(long parent_id, String text, String caption, int options);
	public static native void sorryWId(long parent_id, String text, String caption);
	public static native void sorryWId(long parent_id, String text);
	/**
		 Displays a "Sorry" dialog with a "Details >>" button.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param details Detailed message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Sorry").
			@param options see OptionsType
			 Either your program messed up and asks for understanding
		 or your user did something stupid.
			 To be used for small problems like
		 "Sorry, I can't find the file you specified."
			 And then <code>details</code> can contain something like
		 "foobar.txt was not found in any of
		  the following directories:
		  /usr/bin,/usr/local/bin,/usr/sbin"
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			 NOTE: The ok button will always have the i18n'ed text '&OK'.
		  		@short    Displays a "Sorry" dialog with a "Details >>" button.
	*/
	public static native void detailedSorry(TQWidget parent, String text, String details, String caption, int options);
	public static native void detailedSorry(TQWidget parent, String text, String details, String caption);
	public static native void detailedSorry(TQWidget parent, String text, String details);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void detailedSorryWId(long parent_id, String text, String details, String caption, int options);
	public static native void detailedSorryWId(long parent_id, String text, String details, String caption);
	public static native void detailedSorryWId(long parent_id, String text, String details);
	/**
		 Display an "Information" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Information").
			@param dontShowAgainName If provided, a checkbox is added with which
		                further notifications can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
			@param options see OptionsType
			 Your program wants to tell the user something.
		 To be used for things like:
		 "Your bookmarks have been rearranged."
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			  NOTE: The OK button will always have the i18n'ed text '&OK'.
		  		@short    Display an "Information" dialog.
	*/
	public static native void information(TQWidget parent, String text, String caption, String dontShowAgainName, int options);
	public static native void information(TQWidget parent, String text, String caption, String dontShowAgainName);
	public static native void information(TQWidget parent, String text, String caption);
	public static native void information(TQWidget parent, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void informationWId(long parent_id, String text, String caption, String dontShowAgainName, int options);
	public static native void informationWId(long parent_id, String text, String caption, String dontShowAgainName);
	public static native void informationWId(long parent_id, String text, String caption);
	public static native void informationWId(long parent_id, String text);
	/**
		 Display an "Information" dialog with a listbox.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param strlist List of strings to be written in the listbox. If the
		                list is empty, it doesn't show any listbox, working
		                as information.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("Information").
			@param dontShowAgainName If provided, a checkbox is added with which
		                further notifications can be turned off.
		                The string is used to lookup and store the setting
		                in the applications config file.
		                The setting is stored in the "Notification Messages" group.
			@param options see OptionsType
			 Your program wants to tell the user something.
		 To be used for things like:
		 "The following bookmarks have been rearranged:"
			 The default button is "&OK". Pressing "Esc" selects the OK-button.
			  NOTE: The OK button will always have the i18n'ed text '&OK'.
				@short    Display an "Information" dialog with a listbox.
	*/
	public static native void informationList(TQWidget parent, String text, String[] strlist, String caption, String dontShowAgainName, int options);
	public static native void informationList(TQWidget parent, String text, String[] strlist, String caption, String dontShowAgainName);
	public static native void informationList(TQWidget parent, String text, String[] strlist, String caption);
	public static native void informationList(TQWidget parent, String text, String[] strlist);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void informationListWId(long parent_id, String text, String[] strlist, String caption, String dontShowAgainName, int options);
	public static native void informationListWId(long parent_id, String text, String[] strlist, String caption, String dontShowAgainName);
	public static native void informationListWId(long parent_id, String text, String[] strlist, String caption);
	public static native void informationListWId(long parent_id, String text, String[] strlist);
	/**
		 Enable all messages which have been turned off with the
		 <code>dontShowAgainName</code> feature.
		   		@short    Enable all messages which have been turned off with the  <code>dontShowAgainName</code> feature.
	*/
	public static native void enableAllMessages();
	/**
		 Re-enable a specific <code>dontShowAgainName</code> messages that had
		 previously been turned off.
				@short    Re-enable a specific <code>dontShowAgainName</code> messages that had   previously been turned off.
		@see #saveDontShowAgainYesNo
		@see #saveDontShowAgainContinue
	*/
	public static native void enableMessage(String dontShowAgainName);
	/**
		 Display an "About" dialog.
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param text Message string.
			@param caption Message box title. The application name is added to
		                the title. The default title is i18n("About \<appname\>").
			@param options see OptionsType
			 Your program wants to show some general information about the application
		 like the authors's names and email addresses.
			 The default button is "&OK".
			  NOTE: The ok button will always have the i18n'ed text '&OK'.
		   		@short    Display an "About" dialog.
	*/
	public static native void about(TQWidget parent, String text, String caption, int options);
	public static native void about(TQWidget parent, String text, String caption);
	public static native void about(TQWidget parent, String text);
	/**
		 Alternate method to show a messagebox:
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param type type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			@param text Message string.
			@param caption Message box title.
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param dontShowAskAgainName If provided, a checkbox is added with which
		                further questions/informations can be turned off. If turned off
		                all questions will be automatically answered with the
		                last answer (either Yes or No), if the message box needs an answer.
		                The string is used to lookup and store the setting
		                in the applications config file.
			@param options see OptionsType
		 Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
		       and for Information, none is used.
				@return a button code, as defined in KMessageBox.

		@short    Alternate method to show a messagebox:
	*/
	public static native int messageBox(TQWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontShowAskAgainName, int options);
	public static native int messageBox(TQWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontShowAskAgainName);
	/**
		 Alternate method to show a messagebox:
			@param parent If <code>parent</code> is 0, then the message box becomes an
		                application-global modal dialog box. If <code>parent</code> is a
		                widget, the message box becomes modal relative to parent.
			@param type type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			@param text Message string.
			@param caption Message box title.
			@param buttonYes The text for the first button.
		                  The default is i18n("&Yes").
			@param buttonNo The text for the second button.
		                  The default is i18n("&No").
			@param options see OptionsType
		 Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
		       and for Information, none is used.
				@return a button code, as defined in KMessageBox.

		@short    Alternate method to show a messagebox:
	*/
	public static native int messageBox(TQWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, int options);
	public static native int messageBox(TQWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int messageBox(TQWidget parent, int type, String text, String caption, KGuiItem buttonYes);
	public static native int messageBox(TQWidget parent, int type, String text, String caption);
	public static native int messageBox(TQWidget parent, int type, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native int messageBoxWId(long parent_id, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontShowAskAgainName, int options);
	public static native int messageBoxWId(long parent_id, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontShowAskAgainName);
	public static native int messageBoxWId(long parent_id, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo);
	public static native int messageBoxWId(long parent_id, int type, String text, String caption, KGuiItem buttonYes);
	public static native int messageBoxWId(long parent_id, int type, String text, String caption);
	public static native int messageBoxWId(long parent_id, int type, String text);
	/**
		 Like messageBox
			 Only for message boxes of type Information, Sorry or Error.
			 This function will return immediately, the messagebox will be shown
		 once the application enters an event loop and no other messagebox
		 is being shown.
			 Note that if the parent gets deleted, the messagebox will not be
		 shown.
		     		@short    Like messageBox
	*/
	public static native void queuedMessageBox(TQWidget parent, int type, String text, String caption, int options);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void queuedMessageBoxWId(long parent_id, int type, String text, String caption, int options);
	/**
		 @overload
			 This is an overloaded member function, provided for convenience.
		 It behaves essentially like the above function.
		     		@short    @overload
	*/
	public static native void queuedMessageBox(TQWidget parent, int type, String text, String caption);
	public static native void queuedMessageBox(TQWidget parent, int type, String text);
	/**
		 This function accepts the window id of the parent window, instead
		 of TQWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of TQWidget .
	*/
	public static native void queuedMessageBoxWId(long parent_id, int type, String text, String caption);
	public static native void queuedMessageBoxWId(long parent_id, int type, String text);
	/**
			@param dontShowAgainName the name that identify the message box. If
		 empty, true is always returned.
			@param result is set to the result (Yes or No) that was chosen the last
		 time the message box was shown. Only meaningful, if the message box
		 should not be shown.
				@return true if the corresponding yes/no message box should be shown.

		@short
	*/
	public static native boolean shouldBeShownYesNo(String dontShowAgainName, int result);
	/**
			@param dontShowAgainName the name that identify the message box. If
		 empty, true is always returned.
				@return true if the corresponding continue/cancel message box should be
 shown.

		@short
	*/
	public static native boolean shouldBeShownContinue(String dontShowAgainName);
	/**
		 Save the fact that the yes/no message box should not be shown again.
			@param dontShowAgainName the name that identify the message box. If
		 empty, this method does nothing.
			@param result the value (Yes or No) that should be used as the result
		 for the message box.
				@short    Save the fact that the yes/no message box should not be shown again.
	*/
	public static native void saveDontShowAgainYesNo(String dontShowAgainName, int result);
	/**
		 Save the fact that the continue/cancel message box should not be shown
		 again.
			@param dontShowAgainName the name that identify the message box. If
		 empty, this method does nothing.
				@short    Save the fact that the continue/cancel message box should not be shown  again.
	*/
	public static native void saveDontShowAgainContinue(String dontShowAgainName);
	/**
		 Use <code>cfg</code> for all settings related to the dontShowAgainName feature.
		 If <code>cfg</code> is 0 (default) TDEGlobal.config() will be used.
				@short    Use <code>cfg</code> for all settings related to the dontShowAgainName feature.
	*/
	public static native void setDontShowAskAgainConfig(TDEConfig cfg);
	/**
		 Create content and layout of a standard dialog
			@param dialog The parent dialog base
			@param icon Which predefined icon the message box shall show.
			@param text Message string.
			@param strlist List of strings to be written in the listbox.
		                If the list is empty, it doesn't show any listbox
			@param ask The text of the checkbox. If empty none will be shown.
			@param checkboxReturn The result of the checkbox. If it's initially
		                true then the checkbox will be checked by default.
			@param options see OptionsType
			@param details Detailed message string.
				@return A KDialogBase button code, not a KMessageBox button code,
         based on the buttonmask given to the constructor of the
         <code>dialog</code> (ie. will return KDialogBase.Yes [256] instead of
         KMessageBox.Yes [3]). Will return KMessageBox.Cancel
         if the message box is queued for display instead of
         exec()ed immediately or if the option NoExec is set.
 @note   The <code>dialog</code> that is passed in is deleted by this
         function. Do not delete it yourself.

		@short    Create content and layout of a standard dialog
	*/
	public static native int createKMessageBox(KDialogBase dialog, int icon, String text, String[] strlist, String ask, boolean[] checkboxReturn, int options, String details);
	public static native int createKMessageBox(KDialogBase dialog, int icon, String text, String[] strlist, String ask, boolean[] checkboxReturn, int options);
	/**
		 Create content and layout of a standard dialog
			@param dialog The parent dialog base
			@param icon A TQPixmap containing the icon to be displayed in the
		                dialog next to the text.
			@param text Message string.
			@param strlist List of strings to be written in the listbox.
		                If the list is empty, it doesn't show any listbox
			@param ask The text of the checkbox. If empty none will be shown.
			@param checkboxReturn The result of the checkbox. If it's initially
		                true then the checkbox will be checked by default.
			@param options see OptionsType
			@param details Detailed message string.
			@param notifyType The type of notification to send when this message
		                is presentend.
				@return A KDialogBase button code, not a KMessageBox button code,
         based on the buttonmask given to the constructor of the
         <code>dialog</code> (ie. will return KDialogBase.Yes [256] instead of
         KMessageBox.Yes [3]). Will return KMessageBox.Cancel
         if the message box is queued for display instead of
         exec()ed immediately or if the option NoExec is set.
 @note   The <code>dialog</code> that is passed in is deleted by this
         function. Do not delete it yourself.

		@short    Create content and layout of a standard dialog
	*/
	public static native int createKMessageBox(KDialogBase dialog, TQPixmap icon, String text, String[] strlist, String ask, boolean[] checkboxReturn, int options, String details, int notifyType);
	public static native int createKMessageBox(KDialogBase dialog, TQPixmap icon, String text, String[] strlist, String ask, boolean[] checkboxReturn, int options, String details);
	public static native int createKMessageBox(KDialogBase dialog, TQPixmap icon, String text, String[] strlist, String ask, boolean[] checkboxReturn, int options);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
