/*
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <iostream>

#include "application.h"
static const char *description = I18N_NOOP(
        "TDEBluetooth is a bluetooth manager\nfor the Trinity Desktop.");

static TDECmdLineOptions options[] =
{
        {
                "dontforceshow",
                I18N_NOOP("Show the tray icon if it was disabled before."),
                0
        },
        { 0, 0, 0 }
};

extern "C" TDE_EXPORT int kdemain(int argc, char **argv)
{
    TDELocale::setMainCatalogue("tdebluez");
    TDEAboutData aboutData( "tdebluez",
                I18N_NOOP("TDEBluetooth"),
                0,
                description,
                TDEAboutData::License_GPL,
                "(c) 2018-, Emanoil Kotsev\n(c) 2003-2004, Fred Schaettgen",
                0,
                "http://trinitydesktop.org");
    aboutData.addAuthor( "Emanoil Kotsev",
                I18N_NOOP("Port to TDE and fundamental rework with Bluez5"),
                "deloptes@gmail.com");
    TDECmdLineArgs::init(argc, argv, &aboutData);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEUniqueApplication::addCmdLineOptions();

    if (!TDEUniqueApplication::start())
    {
        std::cerr << i18n("TDEBluetooth is already running.\n").local8Bit();
        return 0;
    }

    TDEBluetoothApp a;

    if (!a.isConnected())
    {
        KMessageBox::error(NULL, i18n("Can't connect to DBus!\nUnable to start tdebluez.\n\n"
                                      "Restart dbus and the bluetooth service"));
        // debug message for testing
        std::cerr << i18n("Can't connect to DBus!\n").local8Bit();
        TDEUniqueApplication::tdeApplication()->quit();
        return 0;
    }
    else
    {
        return a.exec();
    }

}

