/*
 *
 *  MediaControl for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <kdebug.h>

#include <tdelocale.h>
#include <tqpushbutton.h>
#include <tqslider.h>
#include <kiconloader.h>
#include "mediacontrol.h"

MediaControl::MediaControl(TQString path, TQT_DBusConnection *conn) :
        MediaCtlDlg()
{
    pixStart = TDEGlobal::iconLoader()->loadIcon("media-playback-start", TDEIcon::Small, 22);
    pixPause = TDEGlobal::iconLoader()->loadIcon("media-playback-pause", TDEIcon::Small, 22);

    tQPushButtonPlay->setPixmap(pixStart);
    tQPushButtonSeekForward->setPixmap(TDEGlobal::iconLoader()->loadIcon("media-seek-forward", TDEIcon::Small, 22));
    tQPushButtonSeekBackward->setPixmap(TDEGlobal::iconLoader()->loadIcon("media-seek-backward", TDEIcon::Small, 22));
    tQPushButtonForward->setPixmap(TDEGlobal::iconLoader()->loadIcon("media-skip-forward", TDEIcon::Small, 22));
    tQPushButtonBackward->setPixmap(TDEGlobal::iconLoader()->loadIcon("media-skip-backward", TDEIcon::Small, 22));
    tQPushButtonStop->setPixmap(TDEGlobal::iconLoader()->loadIcon("media-playback-stop", TDEIcon::Small, 22));

    tQVolumeSlider->setTracking(false);
    tQVolumeSlider->setRange(0, 100);
    volume = 50;
    tQVolumeSlider->setValue(volume);

    mPath = path;
    mediaCtlProxy = new org::bluez::MediaControl1Proxy("org.bluez", path);
    mediaCtlProxy->setConnection((*(conn)));

    connect((TQObject*) tQPushButtonPlay, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotPlay()));
    connect((TQObject*) tQPushButtonPlay, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotPlayToggled(bool)));
    connect((TQObject*) tQPushButtonSeekForward, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotFastForward()));
    connect((TQObject*) tQPushButtonSeekBackward, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotRewind()));
    connect((TQObject*) tQPushButtonForward, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotNext()));
    connect((TQObject*) tQPushButtonBackward, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotPrevious()));
    connect((TQObject*) tQPushButtonStop, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotStop()));
    //	tQProgressSlider
    connect((TQObject*) tQVolumeSlider, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(slotVolumeValueChanged(int)));
    //	tQPushButtonRepeat
    show();
}

MediaControl::~MediaControl()
{
    if (mediaCtlProxy)
        delete mediaCtlProxy;
}

//void MediaControl::closeMediaControl()
//{
//
//}

void MediaControl::slotPlay()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->Play(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media Play failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotPlayToggled(bool state)
{
    kdDebug() << k_funcinfo << endl;
    if (state)
    {
        tQPushButtonPlay->setPixmap(pixPause);
    }
    else
    {
        slotPause();
        tQPushButtonPlay->setPixmap(pixStart);
    }
}

void MediaControl::slotStop()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    if (mediaCtlProxy->Stop(dbuserror))
    {
        if (tQPushButtonPlay->isOn())
            tQPushButtonPlay->toggle();
    }

    if (dbuserror.isValid())
        tqDebug(i18n("Media Stop failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotPause()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->Pause(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media Pause failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotNext()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->Next(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media Next failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotPrevious()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->Previous(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media Previous failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotFastForward()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->FastForward(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media FastForward failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotRewind()
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    mediaCtlProxy->Rewind(dbuserror);
    if (dbuserror.isValid())
        tqDebug(i18n("Media Rewind failed: %1").arg(dbuserror.message()));
}

void MediaControl::slotVolumeValueChanged(int val)
{
    kdDebug() << k_funcinfo << endl;
    TQT_DBusError dbuserror;
    if (val > volume)
    {
        TQT_DBusError dbuserror;
        mediaCtlProxy->VolumeUp(dbuserror);
        if (dbuserror.isValid())
            tqDebug(i18n("Media VolumeUp getPowered failed: %1").arg(dbuserror.message()));
    }
    if (val < volume)
    {
        mediaCtlProxy->VolumeDown(dbuserror);
        if (dbuserror.isValid())
            tqDebug(i18n("Media VolumeDown getPowered failed: %1").arg(dbuserror.message()));
    }
    volume = val;
}

#include "mediacontrol.moc"
