/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2004 Chrisitan Esken <esken@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MDWSWITCH_H
#define MDWSWITCH_H

#include <kpanelapplet.h>

#include <tqwidget.h>
#include "volume.h"
#include <tqptrlist.h>
#include <tqpixmap.h>
#include <tqrangecontrol.h>

class TQBoxLayout;
class TQLabel;
class TQPopupMenu;
class TQSlider;

class KLedButton;
class TDEAction;
class TDEActionCollection;
class KSmallSlider;
class TDEGlobalAccel;

class MixDevice;
class VerticalText;
class Mixer;
class ViewBase;

#include "mixdevicewidget.h"

class MDWSwitch : public MixDeviceWidget
{
    TQ_OBJECT
  

public:
    MDWSwitch( Mixer *mixer, MixDevice* md,
	       bool small, TQt::Orientation orientation,
	       TQWidget* parent = 0, ViewBase* mw = 0, const char* name = 0);
    ~MDWSwitch();

    void addActionToPopup( TDEAction *action );
    TQSize sizeHint() const;
    void setBackgroundMode(BackgroundMode m);
    bool eventFilter( TQObject* obj, TQEvent* e );

public slots:
    // GUI hide and show
    void setDisabled();
    void setDisabled(bool);

    // Switch on/off
    void toggleSwitch();
    void setSwitch(bool value);

    void update();
    virtual void showContextMenu();

private:
    void createWidgets();

    TQLabel        *_label;
    VerticalText  *_labelV;
    KLedButton    *_switchLED;
    TQBoxLayout    *_layout;
};

#endif
