/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "page_servchan.h"

#include <tqlistbox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tdeapplication.h>
#include <tdeconfig.h>

PageServChan::PageServChan( TQWidget *parent, const char *name ) : PageServChanBase( parent, name)
{
    connect(serverDeleteItemPB, TQ_SIGNAL(pressed()), this, TQ_SLOT(deletePressedSL()));
    connect(ServerAddItemPB, TQ_SIGNAL(pressed()), this, TQ_SLOT(addPressedSL()));
    connect(chanDeleteItmPB, TQ_SIGNAL(pressed()), this, TQ_SLOT(deletePressedCL()));
    connect(ChanAddItemPB, TQ_SIGNAL(pressed()), this, TQ_SLOT(addPressedCL()));

}

PageServChan::~PageServChan()
{
}

void PageServChan::saveConfig()
{
    TQStringList sLB;
    uint i;
    for(i = 0; i < serverLB->count(); i++){
        TQString txt = serverLB->text(i);
        if(!txt.isNull())
            sLB << txt;
    }
    TDEConfig *conf = tdeApp->config();
    conf->setGroup("ServerList");
    conf->writeEntry("RecentServers", sLB);

    TQStringList sCL;
    for(i = 0; i < channelLB->count(); i++){
        TQString txt = channelLB->text(i);
        if(!txt.isNull())
            sCL << txt;
    }
    conf->setGroup("Recent");
    conf->writeEntry("Channels", sCL);
}

void PageServChan::readConfig( const KSOServChan * )
{
    TDEConfig *conf = tdeApp->config();
    conf->setGroup("ServerList");
    TQStringList recent = conf->readListEntry("RecentServers");
    recent.sort();
    serverLB->insertStringList(recent);
    conf->setGroup("Recent");
    recent = conf->readListEntry("Channels");
    recent.sort();
    channelLB->insertStringList(recent);
}

void PageServChan::defaultConfig()
{
    readConfig();
}

void PageServChan::deletePressedSL() {
    int item = serverLB->currentItem();
    if(item >= 0){
        serverLB->removeItem(item);
    }
    emit modified();
}

void PageServChan::addPressedSL() {
    uint i;
    TQString txt = LineEdit6->text();

    for(i = 0; i < serverLB->count(); i++){
        if(txt == serverLB->text(i)){
            tqWarning("Server already in the list!");
            return;
        }
    }

    serverLB->insertItem(txt);
    serverLB->sort();
    LineEdit6->clear();
    emit modified();
    for(i = 0; i < serverLB->count(); i++){
        if(txt == serverLB->text(i)){
            serverLB->setCurrentItem(i);
            serverLB->ensureCurrentVisible();
            return;
        }
    }
}

void PageServChan::deletePressedCL() {
    int item = channelLB->currentItem();
    if(item >= 0){
        channelLB->removeItem(item);
    }
    emit modified();
}

void PageServChan::addPressedCL() {
    uint i;
    TQString txt = LineEdit6_2->text();

    for(i = 0; i < channelLB->count(); i++){
        if(txt == channelLB->text(i)){
            tqWarning("Server already in the list!");
            return;
        }
    }

    channelLB->insertItem(txt);
    channelLB->sort();
    LineEdit6_2->clear();
    emit modified();
    for(i = 0; i < channelLB->count(); i++){
        if(txt == channelLB->text(i)){
            channelLB->setCurrentItem(i);
            channelLB->ensureCurrentVisible();
            return;
        }
    }
}
#include "page_servchan.moc"
