/*
    This file is part of libtdepim.

    Copyright (c) 1999 Preston Brown <pbrown@kde.org>
    Copyright (c) 1999 Ian Dawes <iadawes@globalserve.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef _KTIMEEDIT_H
#define _KTIMEEDIT_H

#include <tqevent.h>
#include <tqkeycode.h>
#include <tqstring.h>
#include <tqdatetime.h>
#include <tqcombobox.h>

#include <tdeapplication.h>
#include <tdemacros.h>

/**
  This is a class that provides an easy, user friendly way to edit times.
  up/down/ increase or decrease time, respectively.

  @short Provides a way to edit times in a user-friendly manner.
  @author Preston Brown, Ian Dawes
*/
class TDE_EXPORT KTimeEdit : public TQComboBox
{
    TQ_OBJECT
  
  public:
    /** constructs a new time edit. */
    KTimeEdit(TQWidget *parent=0, TQTime qt=TQTime(12,0), const char *name=0);

    virtual ~KTimeEdit();

    /**
      Returns, if a time is selected. Can not return false anymore....
    */
    bool hasTime() const;

    /** returns the time that is currently set in the timeLineEdit. */
    TQTime getTime() const;

    /** returns the preferred size policy of the KTimeEdit */
    TQSizePolicy sizePolicy() const;

    /** return true if input is a valid time and false if not */
    bool inputIsValid() const;

  signals:
    /**
      Emitted every time the time displayed changes. "newt" is the new
      time.
    */
    void timeChanged(TQTime newt);

  public slots:
    /** used to set the time which is displayed to a specific value. */
    void setTime(TQTime qt);

  protected slots:
    void active(int);
    void hilit(int);
    void changedText();

  protected:
    virtual void keyPressEvent(TQKeyEvent *qke);
    void addTime(TQTime qt);
    void subTime(TQTime qt);
    // Update the lineedit text from mTime
    void updateText();

private:
    TQTime mTime;                   // the widget's displayed time.
    //TQString mNoTimeString;
};

#endif
