/***************************************************************************
                       alsa-sound-configuration.h  -  description
                             -------------------
    begin                : Thu Sep 30 2004
    copyright            : (C) 2004 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_ALSA_SOUND_CONFIGURATION_H
#define KRADIO_ALSA_SOUND_CONFIGURATION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "alsa-sound-configuration-ui.h"
#include "alsa-sound.h"
#include "alsa-config-mixer-setting.h"

class TQHBoxLayout;
class TQGridLayout;
class QAlsaMixerElement;
class TQScrollView;
class TQFrame;

class AlsaSoundConfiguration : public AlsaSoundConfigurationUI
{
TQ_OBJECT
  
public :
    AlsaSoundConfiguration (TQWidget *parent, AlsaSoundDevice *);
    ~AlsaSoundConfiguration ();

protected slots:

    void slotOK();
    void slotCancel();
    
    void slotSetDirty();

    void slotUpdateConfig();

    void slotPlaybackCardSelected(const TQString &cardname);
    void slotCaptureCardSelected(const TQString &cardname);

protected:
    int listSoundDevices(KComboBox *combobox, TQMap<TQString, int> *devname2dev, TQMap<int, TQString> *dev2devname, TQMap<int, int> *dev2idx, int card, snd_pcm_stream_t stream);
    void saveCaptureMixerSettings();
    void restoreCaptureMixerSettings();

    AlsaSoundDevice   *m_SoundDevice;
    int                m_currentCaptureCard;
    TQMap<TQString, int> m_name2card,
                       m_name2capturedevice,
                       m_playbackDeviceName2dev,
                       m_captureDeviceName2dev;
    TQMap<int, TQString> m_card2name,
                       m_dev2playbackDeviceName,
                       m_dev2captureDeviceName;
    TQMap<int, int>     m_captureCard2idx,
                       m_captureDevice2idx,
                       m_playbackCard2idx,
                       m_playbackDevice2idx;
    TQGridLayout                       *m_groupMixerLayout;
    TQScrollView                       *m_groupMixerScrollView;
    TQFrame                            *m_groupMixerSubFrame;
    TQMap<TQString, QAlsaMixerElement*>  m_MixerElements;

    TQMap<TQString, AlsaConfigMixerSetting> m_MixerSettings;
    
    bool              m_dirty;
    bool              m_ignore_updates;
};

#endif
