/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KLAMSCAN_H_
#define _KLAMSCAN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <dcopklamscan.h>


class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
class TQListView;
class TQListViewItem;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class CollectionSetup;
class TQToolButton;
class TQHBoxLayout;
class TQDir;

namespace KlamAV
{
    class TabWidget;
    class PageViewer;
}
/**
 * This class serves as the main window for Klamscan.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Klamscan  : public TQWidget, virtual public DCOPKlamscan
{
    TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    Klamscan(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Klamscan();

    /**
     * Use this method to load whatever file/URL you have
     */

    void  setDirName(TQString);
    bool isMultiScan();
    bool scanGoingOn();
protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:

private:
    void setupAccel();
    void setupActions();

private:

signals:

public slots:
    void scan(TQStringList);
    void scanURLs(const TQString &urls);
    void slotScanFile();
    void slotScanDir();
private slots:
    void slotScan();
    void slotAdvOptions();

    void slotStopScanning();
    void slotStartAgain();
    void slotRemoveTab();
    void slotManageButtons(TQWidget *current);
private:
    void setDefaults();
    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo, *check_combo;
    TQCheckBox *recursive_box;
    TQListView *resultview;
    TQPushButton *search_button, *cancel_button;
    TQLabel *status_label, *status2_label,*matches_label,*matches2_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig* config;
    bool errorsEncountered;
    TQPopupMenu* menu;
    TQToolButton* adv_options;
    TQStringList urlsToScan;
    TQString prevdir;
    TQStringList listOfUrlsToScan;
    bool multi_recursive;
    KlamAV::TabWidget* tabBrowser;
    CollectionSetup* setup;
    TQToolButton *m_tabsClose;
    TQToolButton* play;
    TQToolButton* stop;
    TQHBoxLayout* controls;

};

#endif // _KLAMSCAN_H_
