/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __EMAIL_PORTAL_H
#define __EMAIL_PORTAL_H

// Portal
#include "interfaces/emailInterface.h"
#include "interface.h"

struct EmailOpts
{
    TQStringList rcpt;
    TQStringList cc;
    TQStringList bcc;
    TQString subj;
    TQString body;
    TQStringList attach;
};

class TDEEmailPortal : public TQObject,
                       public org::freedesktop::impl::portal::EmailInterface
{
    public:
        INTERFACE("org.freedesktop.impl.portal.Email")

        TDEEmailPortal(TQT_DBusConnection &connection);
        virtual ~TDEEmailPortal();

    protected:
        virtual void handleMethodReply(const TQT_DBusMessage& reply);
        virtual bool handleSignalSend(const TQT_DBusMessage& reply);

        virtual bool ComposeEmail(const TQT_DBusObjectPath& handle,
                                  const TQString& app_id,
                                  const TQString& parent_window,
                                  const TQT_DBusVariantMap& options,
                                  TQ_UINT32& response,
                                  TQT_DBusVariantMap &results,
                                  TQT_DBusError& error);
    private:
        TQT_DBusConnection m_connection;
};

#endif // __EMAIL_PORTAL_H

// kate: replace-tabs true; tab-width 4; indent-width 4;