#!/usr/bin/env kjscmd

/**
 * Test of TQChildEvent handling. This example will not work at the moment
 * because support for these events is disabled. The problem occurs because we
 * reenter the interpreter if the object was created by js.
 */

var top = new TQVBox();
var hbox = new TQHBox(top, 'button_hbox');
var add = new TQPushButton(hbox, 'add_button');
var del = new TQPushButton(hbox, 'del_button');

add.text = 'Add';
del.text = 'Delete';

top.childInsertEvent = function(ev)
{
  println( 'Inserted!!!!!' );
}

top.childRemoveEvent = function(ev)
{
  println( 'Removed! ' + ev.className );
}

top.addSlot = function()
{
  l = new TQLabel( this, 'demo_label' );
  l.text = 'Hello World';
  l.show();
}

top.delSlot = function()
{
  if ( top.childCount() > 2 ) {
    top.child( top.childCount()-1 ).deleteLater();
  }
}

top.connect( add, 'clicked()', top, 'addSlot' );
top.connect( del, 'clicked()', top, 'delSlot' );

top.show();
application.exec();
