/***************************************************************************
                          javawriter.h  -  description
    This is the "old" code generator that does not support code editing
    in the Modeller but uses significantly less file space because the
    source code is not replicated in the XMI file.
                             -------------------
    copyright            : (C) 2003 Brian Thomas
         (C) 2004  Umbrello UML Modeller Authors <uml-devel@uml.sf.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JAVAWRITER_H
#define JAVAWRITER_H

#include "simplecodegenerator.h"
#include "../umloperationlist.h"
#include "../umlattributelist.h"
#include "../umlassociationlist.h"

class UMLOperation;

/**
  * class JavaWriter is a code generator for UMLClassifier objects.
  * Create an instance of this class, and feed it a UMLClassifier when
  * calling writeClass and it will generate a java source file for
  * that concept
  */
class JavaWriter : public SimpleCodeGenerator {
public:

    /**
     * Constructor, initialises a couple of variables
     */
    JavaWriter();

    /**
     * Destructor, empty
     */
    virtual ~JavaWriter();

    /**
     * call this method to generate java code for a UMLClassifier
     * @param c the class to generate code for
     */
    virtual void writeClass(UMLClassifier *c);

    /**
     * returns "Java"
     */
    virtual Uml::Programming_Language getLanguage();

    /**
     * Overrides method from class CodeGenerator
     */
    TQStringList defaultDatatypes();

private:

    /**
     * Writes class's documentation then the class header
     * public abstract class Foo extents {
     */
    void writeClassDecl(UMLClassifier *c, TQTextStream &java);

    /**
     * Writes the comment and class constructor
     */
    void writeConstructor(UMLClassifier *c, TQTextStream &java);

    /**
     * return true if the two operations have the same name and the same parameters
     * @param op1 first operation to be compared
     * @param op2 second operation to be compared
     */
    static bool compareJavaMethod(UMLOperation *op1, UMLOperation *op2);

    /**
     * return true if the operation is in the list
     * @param umlOp operation to be searched
     * @param opl list of operations
     */
    static bool javaMethodInList(UMLOperation *umlOp, UMLOperationList &opl);

    /**
     * get all operations which a given class inherit from all its super interfaces and get all operations
     * which this given class inherit from all its super classes
     * @param c the class for which we are generating code
     * @param yetImplementedOpList the list of yet implemented operations
     * @param toBeImplementedOpList the list of to be implemented operations
     * @param noClassInPath tells if there is a class between the base class and the current interface
     */
    void getSuperImplementedOperations(UMLClassifier *c, UMLOperationList &yetImplementedOpList ,UMLOperationList &toBeImplementedOpList, bool noClassInPath = true);

    /**
     * get all operations which a given class inherit from all its super interfaces and that should be implemented
     * @param c the class for which we are generating code
     * @param opl the list of operations used to append the operations
     */
    void getInterfacesOperationsToBeImplemented(UMLClassifier *c, UMLOperationList &opl);

     /**
     * write all operations for a given class
     * @param c the class for which we are generating code
     * @param j the stream associated with the output file
     */
    void writeOperations(UMLClassifier *c, TQTextStream &j);

    /**
     * write a list of operations for a given class
     * @param list the list of operations you want to write
     * @param j the stream associated with the output file
     */
    void writeOperations(UMLOperationList &list, TQTextStream &j);

    /**
     * write all attributes for a given class
     * @param c the class for which we are generating code
     * @param j the stream associated with the output file
     */
    void writeAttributes(UMLClassifier *c, TQTextStream &j);

    /**
     * writes the Attribute declarations
     * @param atpub List of public attributes
     * @param atprot list of protected attributes
     * @param atpriv list of private attributes
     * @param java text stream
     */
    void writeAttributeDecls(UMLAttributeList &atpub, UMLAttributeList &atprot,
                             UMLAttributeList &atpriv, TQTextStream &java );

    /**
     * Searches a list of associations for appropriate ones to write out as attributes
     */
    void writeAssociationDecls(UMLAssociationList associations, Uml::IDType id, TQTextStream &java);

    /**
     * Writes out an association as an attribute using Vector
     */
    void writeAssociationRoleDecl(TQString fieldClassName, TQString roleName, TQString multi,
                                  TQString doc, Uml::Visibility visib, TQTextStream &java);

    /**
     * calls @ref writeSingleAttributeAccessorMethods() on each of the attributes in atpub
     */
    void writeAttributeMethods(UMLAttributeList &atpub, Uml::Visibility visibility, TQTextStream &java);

    /**
     * calls @ref writeAssociationRoleMethod() on each of the associations in the given list
     */
    void writeAssociationMethods(UMLAssociationList associations, UMLClassifier *thisClass,
                                 TQTextStream &java);

    /**
     * calls @ref writeSingleAttributeAccessorMethods() or @ref
     * writeVectorAttributeAccessorMethods() on the assocaition
     * role
     */
    void writeAssociationRoleMethod(TQString fieldClassName, TQString roleName, TQString multi,
                                    TQString description, Uml::Visibility visib, Uml::Changeability_Type change,
                                    TQTextStream &java);

    /**
     * Writes getFoo() and setFoo() accessor methods for the attribute
     */
    void writeSingleAttributeAccessorMethods(TQString fieldClassName, TQString fieldVarName,
            TQString fieldName, TQString description,
            Uml::Visibility visibility, Uml::Changeability_Type change,
            bool isFinal, TQTextStream &java);

    /**
     * Writes addFoo() and removeFoo() accessor methods for the Vector attribute
     */
    void writeVectorAttributeAccessorMethods(TQString fieldClassName, TQString fieldVarName,
            TQString fieldName, TQString description,
            Uml::Visibility visibility, Uml::Changeability_Type change,
            TQTextStream &java);

    /**
     * Writes a // style comment
     */
    void writeComment(const TQString &text, const TQString &indent, TQTextStream &java, bool javaDocStyle=false);

    /**
     * Writes a documentation comment
     */
    void writeDocumentation(TQString header, TQString body, TQString end, TQString indent, TQTextStream &java);

    /**
     * Returns the name of the given object (if it exists)
     */
    TQString getUMLObjectName(UMLObject *obj);

    /**
     * Replaces `string' with `String' and `bool' with `boolean'
     */
    TQString fixTypeName(const TQString& string);

    /**
     * check that initial values of strings have quotes around them
     */
    TQString fixInitialStringDeclValue(TQString value, TQString type);

    /**
     * Write a blank line
     */
    void writeBlankLine(TQTextStream& java);

    /**
     * a little method for converting scope to string value
     */
    TQString scopeToJavaDecl(Uml::Visibility scope);

    /**
     * A \n, used at the end of each line
     */
    TQString startline;

    /**
     * Whether or not this concept is an interface.
     */
    bool isInterface;

};


#endif // JAVAWRITER_H

