/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqevent.h>
#include <tqdragobject.h>
#include <tqstrlist.h>
#include <tqfileinfo.h>
#include <tqwhatsthis.h>
#include <tqlistview.h>

// Include files for KDE

#include <tdelocale.h>

// Local include files

#include "batchprocessimageslist.h"
#include "batchprocessimageslist.moc"

namespace KIPIBatchProcessImagesPlugin
{

BatchProcessImagesList::BatchProcessImagesList(TQWidget *parent, const char *name)
                      : TDEListView(parent, name)
{
    setAcceptDrops(true);
    setDropVisualizer(false);
    addColumn(i18n("Source Album"));
    addColumn(i18n("Source Image"));
    addColumn(i18n("Target Image"));
    addColumn(i18n("Result"));
    setSorting(3);
    setItemMargin(3);
    setResizeMode(TQListView::LastColumn);
    setSelectionMode(TQListView::Single);
    setAllColumnsShowFocus ( true );
    TQWhatsThis::add( this, i18n("<p>You can see here the operations' results "
                                "during the process. Double-click on an item for more "
                                "information once the process has ended. "
                                "<p>You can use the \"Add\" button or drag-and-drop "
                                "to add some new items to the list. "
                                "<p>If the items are taken from different Albums "
                                "the process' results will be merged to the target Album.") );
}

void BatchProcessImagesList::dragEnterEvent(TQDragEnterEvent *e)
{
    e->accept(TQUriDrag::canDecode(e));
}

bool BatchProcessImagesList::acceptDrag(TQDropEvent* e) const
{
    return ( TQUriDrag::canDecode(e) );
}

void BatchProcessImagesList::contentsDropEvent(TQDropEvent* e)
{
    droppedImagesItems(e);
}

void BatchProcessImagesList::dropEvent(TQDropEvent *e)
{
    droppedImagesItems(e);
}

void BatchProcessImagesList::droppedImagesItems(TQDropEvent *e)
{
    TQStrList strList;
    TQStringList FilesPath;

    if ( !TQUriDrag::decode(e, strList) ) return;

    TQStrList stringList;
    TQStrListIterator it(strList);
    char *str;

    while ( (str = it.current()) != 0 )
       {
       TQString filePath = TQUriDrag::uriToLocalFile(str);
       TQFileInfo fileInfo(filePath);

       if (fileInfo.isFile() && fileInfo.exists())
          FilesPath.append(fileInfo.filePath());

       ++it;
       }

    if (FilesPath.isEmpty() == false)
       emit addedDropItems(FilesPath);
}

}  // NameSpace KIPIBatchProcessImagesPlugin
