# Copyright 1999-2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="optional"

TRINITY_MODULE_TYPE="applications/graphics"
inherit trinity-base-2

DESCRIPTION="Image viewer for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="GPL-2+"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="mng xcursor"

DEPEND="
	media-gfx/exiv2
	media-libs/libjpeg-turbo
	media-libs/libpng
	mng? ( media-libs/libmng )
	xcursor? ( x11-libs/libXcursor )
"
RDEPEND="${DEPEND}
	~trinity-apps/gwenview-i18n-${PV}
"
# missing USE=kipi:
# - DEPEND:  kipi? ( ~trinity-apps/libkipi-${PV} )
# - RDEPEND: kipi? ( ~trinity-apps/kipi-plugins-${PV} ) not packaged
# - mycmakeargs: -DWITH_KIPI="$(usex kipi)"

PATCHES=(
	"${FILESDIR}/${P}-Fix-FTBFS-because-of-missing-header.patch"
)
src_configure() {
	local mycmakeargs=(
		-DWITH_MNG="$(usex mng)"
		-DWITH_XCURSOR="$(usex xcursor)"
	)

	trinity-base-2_src_configure
}
